package ga.view.interfaces;

import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Rectangle2D;

/**
 * Interface for an phenotype space. This is used to limit objects to a space
 * with fixed dimensions.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public interface IPhenotypeSpace {
  /**
   * Checks if a shape is inside the space and does not intersect the bounds.
   * 
   * @param shape
   *          Shape that has do be in the space.
   * @return <code>true</code> if the shape is fully inside of the space.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public boolean contains(Polygon2D shape);

  /**
   * Gets the outter bounds of the space as rectangle.
   * 
   * @return Bounds rectangle.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public Rectangle2D getOutterBounds();

  /**
   * Calculates the minimum distance of a shape to a wall.
   * 
   * @param shape
   *          The shape to check for distance to a wall.
   * @param angle
   *          The angle of the shape.
   * @return The minimum distance.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public float minDistanceToWall(Polygon2D shape, float angle);
}
